/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class VWDescriptionTableCellRenderer
extends DefaultListCellRenderer
implements TableCellRenderer {
    protected static final Border BORDER_NO_FOCUS = new EmptyBorder(1, 1, 1, 1);
    protected static final Border BORDER_INSETS = new EmptyBorder(new Insets(5, 5, 5, 5));
    private static final ImageIcon ICON_DESCRIPTION = VWImageLoader.createImageIconNoMessage("description.gif");
    private static final ImageIcon ICON_EMPTY_DESCRIPTION = VWImageLoader.createImageIconNoMessage("description_empty.gif");

    public VWDescriptionTableCellRenderer() {
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setComponentOrientation(table.getComponentOrientation());
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(new CompoundBorder(border, BORDER_INSETS));
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    this.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    this.setBackground(col);
                }
            }
        } else {
            this.setBorder(new CompoundBorder(BORDER_NO_FOCUS, BORDER_INSETS));
        }
        if (value != null && value instanceof String) {
            String toolTip = VWStringUtils.formatToolTip((String)value, -1);
            if (toolTip != null && toolTip.length() > 0) {
                this.setToolTipText(toolTip);
                this.setIcon(ICON_DESCRIPTION);
            } else {
                this.setToolTipText(null);
                this.setIcon(ICON_EMPTY_DESCRIPTION);
            }
        } else {
            this.setToolTipText(null);
            this.setIcon(ICON_EMPTY_DESCRIPTION);
        }
        return this;
    }
}

